# R script for Figure 1B
# For drawing the graph, ggplot2 should be installed.

names = factor(rep(c("1:wt", "2:wt+dmso", "3:wt+10", "4:wt+30", "5:wt+100", "6:wt+db10", "7:wt+db100"), c(3, 3, 3, 3, 3, 3, 3)))
PercentControl = c(1676.333333, 1585.333333, 1655.333333, 1833.333333, 1685.333333, 1643.333333, 1741.333333, 1758.333333, 1753.333333, 1628.333333, 1653.333333, 1511.333333, 1275.333333, 1354.333333, 1231.333333, 1277.333333, 1042.333333, -224.6666667, 246.3333333, 733.3333333, 262.3333333)
data=data.frame(names, PercentControl)
anova(aov(PercentControl ~ names))
TukeyHSD(aov(PercentControl ~ names))
mean <- aggregate(PercentControl ~ names, data, mean)
sd <- aggregate(PercentControl ~ names, data, sd)

library(ggplot2)
i <- ggplot(data, aes(y = PercentControl, x = factor(names), colour = factor(names), fill = factor(names), group = factor(names))) + theme_classic()
i <- i + stat_summary(fun.y = "mean", geom = "bar",  width = 0.5, fill = "grey", position = "dodge", colour="black")
i <- i + stat_summary(fun.y = "mean", fun.ymin = function(x)mean(x)-sd(x), fun.ymax = function(x)mean(x) + sd(x), geom = "errorbar", position = position_dodge(width = 0), width = 0.2, colour="black")
i <- i + geom_point(position = position_jitterdodge(jitter.width = 1, jitter.height = 0, dodge.width = .6), colour="red", size = 3)
i <- i + theme_classic() 
i <- i + scale_y_continuous(expand = c(0, 0), limits = c(-500,2000)) 
i <- i + theme(axis.title.x = element_text(size=10, family = "Arial"), axis.title.y = element_text(size=10, family = "Arial"), axis.text.x = element_text(size=10, colour = 1, family = "Arial"), axis.text.y = element_text(size = 10, colour = 1, family = "Arial"))
png("plot1.png", width = 600, height = 300)
i
dev.off() 
